/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndSounds;

public class ShadowWalkerEntity
extends Monster {
    public ShadowWalkerEntity(EntityType<ShadowWalkerEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 4.5).m_22268_(Attributes.f_22284_, 2.0).m_22266_(Attributes.f_22287_);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, this.m_20185_() + this.f_19796_.m_188583_() * 0.2, this.m_20186_() + this.f_19796_.m_188583_() * 0.5 + 1.0, this.m_20189_() + this.f_19796_.m_188583_() * 0.2, 0.0, 0.0, 0.0);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + this.f_19796_.m_188583_() * 0.2, this.m_20186_() + this.f_19796_.m_188583_() * 0.5 + 1.0, this.m_20189_() + this.f_19796_.m_188583_() * 0.2, 0.0, 0.0, 0.0);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + this.f_19796_.m_188583_() * 0.2, this.m_20186_() + this.f_19796_.m_188583_() * 0.5 + 1.0, this.m_20189_() + this.f_19796_.m_188583_() * 0.2, 0.0, 0.0, 0.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)EndSounds.ENTITY_SHADOW_WALKER.m_203334_();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)EndSounds.ENTITY_SHADOW_WALKER_DAMAGE.m_203334_();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)EndSounds.ENTITY_SHADOW_WALKER_DEATH.m_203334_();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected float m_6121_() {
        return MHelper.randRange((float)0.25f, (float)0.5f, (RandomSource)this.f_19796_);
    }

    public float m_6100_() {
        return MHelper.randRange((float)0.75f, (float)1.25f, (RandomSource)this.f_19796_);
    }

    public boolean m_7327_(Entity target) {
        LivingEntity living;
        boolean attack = super.m_7327_(target);
        if (attack && target instanceof LivingEntity && !(living = (LivingEntity)target).m_21023_(MobEffects.f_19610_)) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60));
        }
        return attack;
    }

    private final class AttackGoal
    extends MeleeAttackGoal {
        private final ShadowWalkerEntity walker;
        private int ticks;

        public AttackGoal(ShadowWalkerEntity walker, double speed, boolean pauseWhenMobIdle) {
            super((PathfinderMob)walker, speed, pauseWhenMobIdle);
            this.walker = walker;
        }

        public void m_8056_() {
            super.m_8056_();
            this.ticks = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.walker.m_21561_(false);
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.ticks;
            this.walker.m_21561_(this.ticks >= 5 && this.m_25565_() < this.m_25566_() / 2);
        }
    }
}

